<?php
class Thumbs {
    // NORMALIZAR NOMBRES DE ARCHIVOS
    public static function  safeName($name, $cut=150) {
      $name = str_replace(' ','_',$name);
      $name = str_replace('...','.',$name);
      $name = str_replace('..','.',$name);
      $name = strtolower(htmlentities($name));
      $name = preg_replace('/&(.)acute;/','\\1', $name);
      $name = preg_replace('/&(.)tilde;/','\\1', $name);
      $name = preg_replace('/&(.*)?;/','', $name);
      $name = preg_replace('/([^a-z0-9\._-\s])/','', $name);
      $name = substr($name,0,$cut);
      return trim($name) == '' ? 'unknown' : trim($name);
    }

    /// NUMEROS RANDOM
    public static function  randomkeys($length){
        $pattern = "1234567890abcdefghijklmnopqrstuvwxyz_-";
        $key  = $pattern{rand(0,35)};
        for($i=1;$i<$length;$i++){
    	$key .= $pattern{rand(0,35)};
        }
    	$key .= "_-_";
        return $key;
    }

    /// CON WATERMARK
    public static function  createThumb($temp_file, $dest_dir, $name_file, $max_w, $max_h, $calidad){
      $watermarkfile = "images/watermark.png";
    	$margen = 20;
    	///
    	$watermarkfile_id = imagecreatefrompng($watermarkfile);
    	///
    	imageAlphaBlending($watermarkfile_id, false);
    	imageSaveAlpha($watermarkfile_id, true);
    	///
    	$fileType = strtolower(substr($name_file, strlen($name_file)-3));
    	///
    	switch($fileType){
    		case('gif'):
    				echo "[!] ATENCION: Solo se permite imagenes con el formato .jpeg o .jpg.";
    				exit();
    				//$srcimg = imagecreatefromgif($temp_file);
    			break;
    		case('png'):
    				echo "[!] ATENCION: Solo se permite imagenes con el formato .jpeg o .jpg.";
    				exit();
    		    //$srcimg = imagecreatefrompng($temp_file);
    			 break;
    		default:
    				$srcimg = imagecreatefromjpeg ($temp_file);
    			 break;
    	}
    	///
    	$srcimg_width = imageSX($srcimg);
    	$srcimg_height = imageSY($srcimg);
    	///
    	$watermarkfile_width = imageSX($watermarkfile_id);
    	$watermarkfile_height = imageSY($watermarkfile_id);
    	///
    	if(isset($_REQUEST['imgPhoto_x'])){
    		$dest_x = $_REQUEST['imgPhoto_x'];
    		$dest_y = $_REQUEST['imgPhoto_y'];
    	} else {
    		// ABAJO A LA DERECHA
    		$dest_x = (($srcimg_width - $watermarkfile_width) - $margen);
    		$dest_y = (($srcimg_height - $watermarkfile_height) - $margen);
    	}
    	///
    	imagecopy($srcimg, $watermarkfile_id, $dest_x, $dest_y, 0, 0, $watermarkfile_width, $watermarkfile_height);
    	///
    	list ($width, $height) = getimagesize ($temp_file);
    	//
    	$a = ($max_w/$width);
    	$b = ($max_h/$height);
    	///
    	if($max_w && $width > $max_w){
    			$widthratio = $max_w/$width;
    			$RESIZEWIDTH = true;
    	};
    	///
    	if($max_h && $height > $max_h){
    		$heightratio = $max_h/$height;
    		$RESIZEHEIGHT = true;
    	};
    	///
    	if($RESIZEWIDTH && $RESIZEHEIGHT){
    		if($widthratio < $heightratio){
    			$ratio = $widthratio;
    		}else{
    			$ratio = $heightratio;
    		};
    	} elseif ($RESIZEWIDTH){
    		$ratio = $widthratio;
    	} elseif ($RESIZEHEIGHT){
    		$ratio = $heightratio;
    	} else {
    		$ratio = "1";
    	}
    	///
    	$newwidth = ($width * $ratio);
    	$newheight = ($height * $ratio);
    	///
    	$thumb = imagecreatetruecolor($newwidth, $newheight);
    	///
    	imagecopyresized ($thumb, $srcimg, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
    	///
    	imagejpeg ($thumb, $dest_dir.$name_file, $calidad);
    	///
    	imagedestroy($thumb);
    	///
    	imagedestroy($srcimg);
    	///
    	imagedestroy($watermarkfile_id);
    }

    // SIN WATERMARK
    public static function  createthumbSinW($temp_file, $dest_dir, $name_file, $max_w, $max_h, $calidad){
      $srcimg = imagecreatefromjpeg ($temp_file);
    	///
    	list ($width, $height) = getimagesize ($temp_file);
    	///
    	$a = ($max_w/$width);
    	$b = ($max_h/$height);
    	///
    	if($max_w && $width > $max_w){
    			$widthratio = $max_w/$width;
    			$RESIZEWIDTH=true;
    	};
    	///
    	if($max_h && $height > $max_h){
    		$heightratio = $max_h/$height;
    		$RESIZEHEIGHT=true;
    	};
    	///
    	if($RESIZEWIDTH && $RESIZEHEIGHT){
    		if($widthratio < $heightratio){
    			$ratio = $widthratio;
    		}else{
    			$ratio = $heightratio;
    		};
    	} elseif ($RESIZEWIDTH){
    		$ratio = $widthratio;
    	} elseif ($RESIZEHEIGHT){
    		$ratio = $heightratio;
    	} else {
    		$ratio = "1";
    	}
    	///
    	$newwidth = $width * $ratio;
    	$newheight = $height * $ratio;
    	///
    	$thumb = imagecreatetruecolor(($newwidth), ($newheight));
    	///
    	imagecopyresized ($thumb, $srcimg, 0,0,0,0,($newwidth), ($newheight), $width, $height);
    	///
    	imagejpeg ($thumb, $dest_dir.$name_file, $calidad);
    	///
    	imagedestroy($thumb);
    }

    // UPLOAD DE IMAGEN
    public static function  uploadImage($temp_file, $dest_dir, $name_file, $calidad){
    	$srcimg = imagecreatefromjpeg ($temp_file);
    	///
    	imagejpeg ($srcimg, $dest_dir.$name_file, $calidad);
    	///
    	imagedestroy($srcimg);
    	///
    	echo $srcimg;

    }

    public static function  createThumbCrop($temp_file, $dest_dir, $name_file, $max_w, $max_h, $calidad) {
      $info = getimagesize($temp_file);
      list($ow, $oh, $type, $attr) = $info;
      $destination = (substr($dest_dir,-1) != '/' ? $dest_dir.'/' : $dest_dir).$name_file;
      if (!in_array($type, array(2))) {    // 1=GIF, 2=JPEG, 3=PNG, 6=BMP, 7=TIFF, 8=TIFF
    		echo "<div class=\"mensajeAlerta\">[!] ATENCION: Solo se permite imagenes con el formato .jpeg o .jpg.</div>";
    		exit();
      }

      $x1 = $y1 = 0;
      $dw = $max_w; $dh = $max_h;
      // Mantener relaci�n de aspecto
      $nw = $dw;
      $nh = round($dw * $oh / $ow);
      if ($nh < $dh) {
        $nh = $dh;
        $nw = round($dh * $ow / $oh);
      }
      // Centrar
      if ($dw != $nw) { $x1 = round(($dw - $nw) / 2); }
      if ($dh != $nh) { $y1 = round(($dh - $nh) / 2); }
      // Crear imagen
      $img1 = imagecreatefromjpeg($temp_file);
      $img2 = imagecreatetruecolor($dw,$dh);
      imagecopyresampled($img2, $img1, $x1, $y1, 0, 0, $nw, $nh, $ow, $oh);
      imagejpeg($img2, $destination, $calidad);
    }
}
