<?php
class numberUtils {

    public static function stringToNumber($number) {
        preg_match_all("/([0-9]*)([bkmgt])/si",$number,$matches,PREG_SET_ORDER);
        if ($matches) {
            $number=intVal($matches[0][1]);
            $factor=strtolower($matches[0][2]);
        } else {
            $number=intval($number);
            $factor="b";
        }
        switch($factor) {
            case "k": $number*=1024; break;
            case "m": $number*=1048576; break;
            case "g": $number*=1024*1048576; break;
            case "t": $number*=1048576*1048576; break;
            default: break;
        }
        return $number;
    }

    public static function numberToString($number,$factor) {
        switch(strtolower($factor)) {
            case "k": $number=floor($number/1024); break;
            case "m": $number=floor($number/1048576); break;
            case "g": $number=floor($number/(1024*1048576)); break;
            case "t": $number=floor($number/(1048576*1048576)); break;
            default: break;
        }
        return $number.strtoupper($factor);
    }
}
