<?php
Application::Uses("sys.web.WebPage");

Application::UsesModel("usuarios");
class WebAdmin extends WebPage {
	protected $templateFolder="admin";
    protected $templateFile="main.tpl";

	public function create() {
		parent::create ();
		if ($_GET["raw"]==='1') $this->template="raw_main.tpl";

        $menu=$this->loadMenu();
		$uri=preg_replace("#/admin/#","",$_SERVER["REQUEST_URI"]);
        $uriParts=explode("/",$uri);
        if (count($uriParts)==3) {
            $activeMenu=array_shift($uriParts);
            $activeSubmenu=array_shift($uriParts);
        } else if(count($uriParts)==2) {
            $activeMenu=array_shift($uriParts);
            $activeSubmenu=null;
        } else {
            preg_match_all('#([^/]*)/([^/]*)/([^\.]*)\.php#si',$uri,$matches,PREG_SET_ORDER);
            if (!$matches) {
                preg_match_all('#([^/]*)/([^\.]*)\.php#si',$uri,$matches,PREG_SET_ORDER);
                list($activeMenu,$activeSubmenu)=explode("/",$matches[0][2]);
            } else {
                $activeMenu=$matches[0][1];
                list($activeSubmenu,$s)=explode("/",$matches[0][2]);
            }
        }

		$this->view->assign("menu",$menu);
		if ($this->lifeCycle)
		      $this->view->assign("template","index.tpl");
	}
	protected function processLogin() {
        $usuario = @$_REQUEST["email"];
        $password = @$_REQUEST["password"];
        if ($usuario && $password) {
            $user=TMUsuarios::orWhere([
					["usr_email",$usuario],
					['usr_user',$usuario]
				])
                ->joinUsing(TMUsuariosRoles::alias('ur'),'usr_codigo')
                ->first();

            if ($user) {
				$passOk = passwordUtils::createHash ($password,$user->usr_pass);
				if ($passOk) {
					$_SESSION[$this->sessionUser()]=$user->usr_codigo;
					$_SESSION['valido'] = "true";
					$this->usuario = $user;
					if (Application::get('ENABLE_CHAT')===true) {
						$pusher=new Pusher\Pusher(Application::get("PUSHER_APP_KEY"), Application::get("PUSHER_APP_SECRET"), Application::get("PUSHER_APP_ID"), array('cluster' => Application::get("PUSHER_APP_CLUSTER")));
						$pusher->trigger(Application::get('PUSHER_CHANNEL'),"user-connect",['user_id'=>$this->usuario->usr_codigo]);
					}
					TMActivities::logActivity("Inicio sesión");
					Application::Reload();
				} else {
	                Application::set("error_message","E-mail o contrase&ntilde;a no v&aacute;lidos.");
				}
            } else {
                Application::set("error_message","E-mail o contrase&ntilde;a no v&aacute;lidos.");
            }
        }
    }

    protected function isLoggedIn() {
        if (($_POST["accion"]=="resetPassword" || $_GET["accion"]=="resetPassword") && (isset($_POST["step"]) || isset($_GET["step"]))) {
            $this->openAccess=true;
            return true;
        }
        if (isset($_SESSION[$this->sessionUser()])) {
            $this->usuario=TMUsuarios::find($_SESSION[$this->sessionUser()]);
            return true;
        } else
            return false;
    }

	public function sessionUser() {
		$sessionVar="usuario";
		if (Application::get("BACKEND_SESSION_VAR"))
			$sessionVar=Application::get("BACKEND_SESSION_VAR");
		return $sessionVar;
	}

	public function output() {
        if (Application::session('error_message')) {
            Application::setFromSession('error_message');
            unset($_SESSION['error_message']);
        }
        if (Application::session('flash_message')) {
            Application::setFromSession('flash_message');
            unset($_SESSION['flash_message']);
        }
        if ($this->raw) $this->template="raw.tpl";
        $this->view->assign("currentUser",$_SESSION[$this->sessionUser()]);
        $this->view->assign("usuario",$this->usuario);
		parent::output();
        Application::clearPostData();
    }

	private function loadMenu() {
        $menuFolder=Application::get("SYS_PATH")."/config/menu/backend";
        $menuSetup=@parse_ini_file("{$menuFolder}/menu.ini",true);
        $modulesFolder=$menuFolder."/modules";
        $menuFilesLoaded=array();
        if (file_exists($modulesFolder) && is_dir($modulesFolder)) {
            $d=dir($modulesFolder);
            while($e=$d->read()) {
                if (is_dir($modulesFolder."/".$e)) continue;
                $menuFilesLoaded[$e]=@parse_ini_file("{$modulesFolder}/{$e}",true);
            }
        }
        ksort($menuFilesLoaded);
        foreach($menuFilesLoaded as $f=>$menu) {
            $menuSetup=array_merge($menuSetup,$menu);
        }
        $menu=array();
        if ($menuSetup) {
            foreach($menuSetup as $key=>$values) {
                $keyParts=explode(".",$key);
                foreach($values as $k=>$v) {
                    if ($k=="link") $values[$k]=Application::getLink($v);
                }
                if (count($keyParts)==1) {
                    $menu[$key]=$values;
                } else {
                    $key=$keyParts[0];
                    $subkey=$keyParts[2];
                    if (!isset($menu[$key]["options"])) {
                        $menu[$key]["options"]=array();
                    }
                    $menu[$key]["options"][$subkey]=$values;
                }
            }
        }

        return $menu;
    }
}
