<?php
Application::Uses('sys.web.support.request');
Application::Uses('sys.web.support.session');
Application::Uses("sys.libraries.smarty.Smarty");
class WebPage {
	protected $lifeCycle=array("dispatch","init","run");
    protected $rules="";
    protected $strictRules="";
    protected $template="";
    protected $templateFolder="";
    protected $view=null;
    protected $raw=false;
    protected $pageTitle="";
    protected $breadcrumb=array();
    protected $bc_options=array();
    protected $openAccess=false;
	public $request=null;

	protected $actionRequestVar='accion';

	public $usuario;

	public function __construct() {
//		ini_set("memory_limit",'2048M');
        $this->view=new Smarty();
		$this->request=new Request();
        $this->templateFolder=($this->templateFolder!=""?"/":"").$this->templateFolder;
		$baseDir=Application::get("BASE_DIR");

		$templatesBaseDir=$_SERVER["DOCUMENT_ROOT"].$baseDir."/resources";
		$templatesCompileBaseDir=$_SERVER["DOCUMENT_ROOT"].$baseDir."/resources/".Application::get("TEMPLATE_C_DIR");
		$themeTemplateDir=$templatesBaseDir."/themes/".Application::Get("DEFAULT_THEME")."/templates".($this->templateFolder!=""?"/":"").$this->templateFolder;
		if (file_exists($themeTemplateDir))
			$templatesBaseDir.="/themes/".Application::Get("DEFAULT_THEME")."/templates".($this->templateFolder!=""?"/":"").$this->templateFolder;

		$templatesBaseDir=str_replace("//","/",$templatesBaseDir);
		$templatesCompileBaseDir=str_replace("//","/",$templatesCompileBaseDir);

		$this->view->compile_dir=$templatesCompileBaseDir;

        $this->view->setTemplateDir($templatesBaseDir);
        $this->view->assign("_SERVER",$_SERVER);
		$this->Session=new Session();

        Application::getDatabase();
    	if(class_exists("TMUsuariosRoles"))
            $ru=TMUsuariosRoles::get();
        if(class_exists("TMRules"))
            $ru=TMRules::get();
    }

	public function getView() { return $this->view; }

    public function execute() {
        if ($this->isLoggedIn()) {
			if ($this->usuario) {
				$this->usuario->loadPermissions();
	            if (!empty($this->strictRules)) {
	                if (!$this->usuario->hasRules($this->strictRules)) {
	                    $this->view->assign("template","common/access_denied.tpl");
	                    $this->lifeCycle=array();
	                }
	            } else if (!empty($this->rules)) {
	                if (!$this->usuario->hasRoleOrRule("Superusuario",$this->rules)) {
	                    $this->view->assign("template","common/access_denied.tpl");
	                    $this->lifeCycle=array();
	                }
	            }
			}
			try {
				if ($this->create()!==false) {
					foreach($this->lifeCycle as $method) {
						if(call_user_func(array($this,$method))===false) {
							break;
						}
					}
				}
			} catch(ErrorException $e) {
				$this->view->assign("template","common/error.tpl");
				$this->view->assign("error",debug_backtrace());
			}
        } else {
            $this->processLogin();
            Application::addScript('/resources/js/common/login.js');
            $this->templateFile="login.tpl";
        }
        $this->output();
    }

    protected function processLogin() {}
    protected function create() {}
    protected function isDispatchable() {
		if ($this->openAccess) return true;
        if ($_GET["open"]!=true && !$this->openAccess) {
            $user=TMUsuarios::find($_SESSION[$this->sessionUser()]);
            if (!$user) return false;
			$user->loadPermissions();
        }
        return $user;
    }

    protected function dispatch() {
//		KoshkilLog::debug('------ REQUEST: '.print_r($this->request->all(),true));
        if (!($user=$this->isDispatchable())) return;
		$varAccion=$this->actionRequestVar;
		$accion=$this->request->{$varAccion};
        if ($accion && method_exists($this, "accion_{$accion}")) {
            if ($enforceAttributeCheck=TMRules::actionToAttribute($accion)) {
                if($accion=="eliminar") {
                    if (!empty($this->strictRules)) {
                        if (!$user->hasRules(TMRules::ensureRuleAttribute($this->strictRules,$enforceAttributeCheck))) {
                            Application::set("error_message","No posee los permisos necesarios para la acci&oacute;n");
                            return;
                        }
                    } else if (!empty($this->rules)) {
                        if (!$user->hasRoleOrRule("Superusuario",TMRules::ensureRuleAttribute($this->rules,$enforceAttributeCheck))) {
                            Application::set("error_message","No posee los permisos necesarios para la acci&oacute;n");
                            return;
                        }
                    }
                }
            }
            return call_user_func(array($this, "accion_{$accion}"));
        }
    }
    protected function init() {}
    protected function run() {}

    protected function isLoggedIn() {
        return $this->openAccess || (isset($_SESSION[$this->sessionUser()]));
    }

	public function sessionUser() {
		$sessionVar="usuario";
		return $sessionVar;
	}

    public function output() {
		$tpl=$this->getTemplateName();
		$this->view->assign("template",$tpl);
        $this->view->display($this->templateFile);
    }

    public function getTitle() {
        return $this->title;
    }
    public function getBreadcrumb() {
        return $this->breadcrumb;
    }

    public function getBreadcrumbOptions() {
        return $this->bc_options;
    }

    protected function jsonize($data) {
        header("Content-Type: text/json");
        die(json_encode($data));
    }

	protected function getTemplateName() {
        $template=$this->view->tpl_vars["template"]->value;
        if ($template=="empty.tpl" || !$template) {
			$requestedUri=str_replace($scriptName,"",$_SERVER["REQUEST_URI"]);
			list($uri,$qs)=@explode("?",$requestedUri);
			if (substr($uri,0,strlen(Application::get("BASE_DIR")))==Application::get("BASE_DIR"))
				$uri=substr($uri,strlen(Application::get("BASE_DIR")));

			$sep=(substr($uri,0,1)!="/"?"/":"");
			$uri=strtolower(dirname($uri)."/".basename($uri,".php"));
            $uri=str_replace("//","/",$uri);
            $uri=str_replace("\\/","/",$uri);
			if (substr($uri,0,10)=="/index.php") $uri=substr($uri,10);
			if (substr($uri,0,1)=="/") $uri=substr($uri,1);
			if (empty($uri)) $uri="index";
			//$uri=str_replace("-","_",$uri);
			$template=$uri.".tpl";
			$remove=$this->templateFolder;
			if (substr($remove,0,1)=="/") $remove=substr($remove,1);

			if (substr($template,0,strlen($remove))==$remove)
				$template=substr($template,strlen($remove));

			if ($template==".tpl")
				$template=$uri.".tpl";

			$baseDir=Application::get("BASE_DIR");

			$templatesBaseDir=$_SERVER["DOCUMENT_ROOT"].$baseDir."/resources";
			$themeTemplateDir=$templatesBaseDir."/themes/".Application::Get("DEFAULT_THEME")."/templates".($this->templateFolder!=""?"/":"").$this->templateFolder;
			if (file_exists($themeTemplateDir))
				$templatesBaseDir.="/themes/".Application::Get("DEFAULT_THEME")."/templates".($this->templateFolder!=""?"/":"").$this->templateFolder;

			$templatesBaseDir=str_replace("//","/",$templatesBaseDir);
			if (!file_exists($templatesBaseDir."/{$template}")) {
				echo "<!-- {$templatesBaseDir}/{$template} -->";
				$template="404.tpl";
			}
			if (!file_exists($templatesBaseDir."/{$template}")) {
				$templatesBaseDir=$_SERVER["DOCUMENT_ROOT"].$baseDir."/resources/templates";
				if (!file_exists($templatesBaseDir."/{$template}")) {
					throw new Exception($templatesBaseDir."/{$template} noexiste!");
					$template="empty.tpl";
				} else {
					$template=$templatesBaseDir."/{$template}";
				}
			}
		}
        return $template;
    }

	protected function set($vars) {
		foreach($vars as $key => $val) {
			$this->view->assign($key,$val);
		}
	}
}
